require "prefabutil"

local assets=
{
	Asset( "ANIM", "anim/badgeoftruce.zip" ),
	Asset("IMAGE", "images/inventoryimages/badgeoftruce.tex"),
	Asset("ATLAS", "images/inventoryimages/badgeoftruce.xml"),
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "badgeoftruce", "swap_body")
	owner:AddTag("truce")
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner:RemoveTag("truce")
	
end



local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
        	
    inst.AnimState:SetBank("badgeoftruce")
    inst.AnimState:SetBuild("badgeoftruce")
    inst.AnimState:PlayAnimation("idle", false)
	
	MakeInventoryPhysics(inst)

	
	inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/badgeoftruce.xml"
    
    	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.NECK or EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )


    return inst
end


return Prefab( "common/inventory/badgeoftruce", fnab, assets) 